#!/usr/bin/perl

# Usage: regexp-dir.pl dirname 's/\.ZIP$/\.zip/i'
# Actually, you can put any perl code in between the single quotes
# that modifies $_.

#====================================================================
# Syntax: RegexpOnDirectory(<dirname>, sub { s/abc/def/ });
# Pretty easy to use.
#====================================================================

sub RegexpOnDirectory ($&) {
	my $Dirname = shift;
	my $CODEREF = shift;	# We do this on raw filenames.
	
	
	my $ent;
	my $ent2;		# Copy of ent that can be modified.

	
	# <CONFUSE_READER>
	# In case we want to call ourselves, this next line ensures we
	# won't get a busy signal.  (Methinks it makes a local globtype.)
	# It worked in another script I did for electrical circuit design.
	# </CONFUSE_READER>
	
	local *DIRHANDLE;
	
	# Localize '$_' so that the CODEREF feature works.  For some reason,
	# the " =~ " operator doesn't seem to work on the coderef.
	# This way, the value of '$_' before RegexpOnDirectory gets protected.
	local $_;
	
	
	
	# I have to search ALL of the directory entries because some idiot 
	# might try to give me fubar.zIp or biteme.Txt.  Besides, this 
	# bypasses glob.
	
	opendir(DIRHANDLE, $Dirname)
		or return -1;
	
	while ($ent = readdir(DIRHANDLE)) {
		$_ = $ent;
		&$CODEREF();
		$ent2 = $_;
		
		if ($ent ne $ent2) {
			$OldName = $Dirname . "/" . $ent;
			$NewName = $Dirname . "/" . $ent2;

			if (-e $NewName) {
				print "File '$NewName' already exists!\n";
				next;
			}
			print "Renaming '$OldName' to '$NewName'...\n";
			rename($OldName, $NewName);
		}
	}
	
	closedir(DIRHANDLE);
	return 0;
}

$DirName = shift(@ARGV);

RegexpOnDirectory($DirName, sub { foreach $s (@ARGV) { eval($s) } } );
